/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.generaltab.VWSIMGeneralTab;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourcesPropertiesTab;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMRolesPropertiesTab;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMShiftsPropertiesTab;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModelessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMScenarioPropertiesDialog
extends VWModelessDialog
implements IVWFrameInterface,
ActionListener,
ChangeListener {
    private static final int WINDOW_WIDTH = 790;
    private static final int WINDOW_HEIGHT = 480;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_RESOURCES = 1;
    private static final int TAB_SHIFTS = 2;
    private static final int TAB_ROLES = 3;
    private VWSIMPropertyData m_propertyData = null;
    private JTabbedPane m_tabbedPane = null;
    private VWSIMGeneralTab m_generalTab = null;
    private VWSIMResourcesPropertiesTab m_resourcesTab = null;
    private VWSIMShiftsPropertiesTab m_shiftsTab = null;
    private VWSIMRolesPropertiesTab m_rolesTab = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;

    public VWSIMScenarioPropertiesDialog(VWSIMPropertyData propertyData) {
        super(propertyData.getParentFrame(), propertyData.getSessionInfo());
        try {
            this.m_propertyData = propertyData;
            if (!this.updateWindowPosition("scenario_properties_location", "scenario_properties_size")) {
                Dimension dim = VWStringUtils.stringToDimension(VWSIMResource.s_scenarioPropertiesDialogDim);
                if (dim == null) {
                    this.updateWindowPosition(790, 480, 0);
                } else {
                    this.updateWindowPosition(dim.width, dim.height, 0);
                }
            }
            this.setTitle(VWSIMResource.s_scenarioPropertiesDlgTitle);
            this.setVisible(false);
            this.reinitialize();
            this.addWindowListener(new VWWindowAdapter(this));
            this.m_tabbedPane.addChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setVisible(boolean bShow) {
        boolean bWasVisible = this.isVisible();
        super.setVisible(bShow);
        if (bWasVisible && !bShow) {
            this.saveWindowPosition("scenario_properties_location", "scenario_properties_size");
        }
    }

    public void reinitialize() {
        try {
            int nCurrentTabIndex = -1;
            if (this.m_tabbedPane != null) {
                nCurrentTabIndex = this.m_tabbedPane.getSelectedIndex();
            }
            this.getContentPane().removeAll();
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.m_tabbedPane = new JTabbedPane(1);
            this.m_generalTab = new VWSIMGeneralTab();
            this.m_generalTab.init(this.m_propertyData);
            JScrollPane scrollPane = new JScrollPane(this.m_generalTab);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_tabbedPane.addTab(VWSIMResource.s_generalTab, VWSIMImageLoader.createImageIcon("scenario.gif"), scrollPane);
            this.m_resourcesTab = new VWSIMResourcesPropertiesTab();
            this.m_resourcesTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_resourcesPropertiesTab, VWSIMImageLoader.createImageIcon("resource16.gif"), this.m_resourcesTab);
            this.m_shiftsTab = new VWSIMShiftsPropertiesTab();
            this.m_shiftsTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_shiftsPropertiesTab, VWSIMImageLoader.createImageIcon("shift16.gif"), this.m_shiftsTab);
            this.m_rolesTab = new VWSIMRolesPropertiesTab();
            this.m_rolesTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_jobsPropertiesTab, VWSIMImageLoader.createImageIcon("role16.gif"), this.m_rolesTab);
            this.getContentPane().add((Component)this.m_tabbedPane, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            if (nCurrentTabIndex != -1) {
                this.showTab(nCurrentTabIndex);
            }
            super.updateComponentOrientation();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void showTab(int nTabIndex) {
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.setSelectedIndex(nTabIndex);
        }
    }

    public void releaseReferences() {
        if (this.m_generalTab != null) {
            this.m_generalTab.releaseReferences();
            this.m_generalTab = null;
        }
        if (this.m_resourcesTab != null) {
            this.m_resourcesTab.releaseReferences();
            this.m_resourcesTab = null;
        }
        if (this.m_shiftsTab != null) {
            this.m_shiftsTab.releaseReferences();
            this.m_shiftsTab = null;
        }
        if (this.m_rolesTab != null) {
            this.m_rolesTab.releaseReferences();
            this.m_rolesTab = null;
        }
    }

    public void windowClosing(WindowEvent event) {
        if (this.m_propertyData != null) {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
        }
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_closeButton)) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        } else if (event.getSource().equals(this.m_helpButton)) {
            this.performHelpAction();
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof JTabbedPane) {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_closeButton = new JButton(VWSIMResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWSIMResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void performHelpAction() {
        if (this.m_tabbedPane == null) {
            return;
        }
        StringBuffer helpString = new StringBuffer(VWSIMHelp.Help_Simulation_Designer + "scenariopropertiesdialog_");
        switch (this.m_tabbedPane.getSelectedIndex()) {
            case 0: {
                helpString.append("general");
                break;
            }
            case 3: {
                helpString.append("jobs");
                break;
            }
            case 2: {
                helpString.append("shifts");
                break;
            }
            case 1: {
                helpString.append("resources");
                break;
            }
            default: {
                return;
            }
        }
        helpString.append(".htm");
        VWSIMHelp.displayPage(helpString.toString());
    }
}

